use AdventureWorks2008
go

/* In command prompt:
cd /D "%userprofile%\My Documents\Visual Studio 2008\Projects\SQLCLR\c#"
%windir%\Microsoft.NET\Framework\v3.5\csc /t:library Foo.cs
*/

--Make sure if the functions have already been defined or the assembly already loaded, we lose them now
drop function Decorate
drop function Leetify
drop assembly Foo
go

--Map in the assembly
create assembly Foo from 'C:\Documents and Settings\Administrator\My Documents\Visual Studio 2008\Projects\SQLCLR\Foo.dll'
with permission_set = safe
go

--Map the assembly functions
/*
Note if class is not in a namespace then it's:
  assembly.class.method
else it's:
  assembly.[namespace.class].method
*/
create function Decorate(@string_in as nvarchar(25)) returns nvarchar(31)
as
external name Foo.[Misc.TextRoutines].ExpandWithExclamationMarks
go

create function Leetify(@string_in as nvarchar(25)) returns nvarchar(33)
as
external name Foo.[Misc.TextRoutines].ToLeet
go

/*
sp_configure 'clr enabled', 1
go
reconfigure with override
go
*/

select FirstName, dbo.Decorate(LastName)
from Person.Person
where LastName = 'Adams'

select
  dbo.Leetify(FirstName + ' ' + LastName) as 'Filtered Full Name',
  dbo.Decorate(FirstName + ' ' + LastName) as 'Decorated Full Name',
  FirstName + ' ' + LastName as 'Full Name'
from Person.Person
where LastName = 'Adams'
